<?php
$info = model('App\Models\SchoolInfoModel')->find(1);

$logo = !empty($info['logo_path']) ? base_url($info['logo_path']) : base_url('assets/images/logo1.png');
$schoolName = !empty($info['school_name']) ? esc($info['school_name']) : 'SMAS SENTOSA BHAKTI';
$heroBg = !empty($info['hero_bg_path']) ? "background-image:url('".base_url($info['hero_bg_path'])."');" : '';
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title><?= $schoolName ?></title>

  <link rel="stylesheet" href="<?= base_url('assets/css/galeri.css') ?>">
  <link rel="stylesheet" href="<?= base_url('assets/fontawesome/css/all.css') ?>">
  <link rel="icon" href="<?= base_url('assets/images/logo1.png') ?>" type="image/png">
  
  <style>
    :root{
      --hero-bg: url("<?= base_url($info['hero_bg_path'] ?? 'assets/images/fotologo.jpg') ?>");
    }
</style>
<body>

<nav>
  <div class="left-box">
    <img src="<?= $logo ?>" alt="Logo">
    <span class="school-name"><?= $schoolName ?></span>
  </div>

  <ul>
    <a href="<?= base_url() ?>">Beranda</a>
    <a href="<?= base_url('berita') ?>">Berita</a>
    <a href="<?= base_url('galeri') ?>">Galeri</a>
    <a href="<?= base_url('tentang') ?>">Tentang</a>
  </ul>
</nav>


  <!-- CONTENT MAIN -->
  <main class="content" id="galeri">

    <!-- CENTER TITLE -->
    <div class="center-title">
      <div class="title-box">GALERI</div>
    </div>

    <!-- TEXT DI BAWAH NAVBAR -->
    <p class="galeri-desc">
      Jelajahi momen terbaik di SMAS Sentosa Bhakti — dari kegiatan belajar, prestasi,
      kebersamaan siswa-siswi, hingga ragam ekstrakurikuler yang membentuk karakter.
    </p>

    <!-- CATEGORY BUTTONS -->
    <div class="category-row" role="tablist" aria-label="Kategori galeri">
      <button class="cat-btn is-active" data-cat="guru" role="tab" aria-selected="true">
        <span>GURU DAN STAF</span>
      </button>
      <button class="cat-btn" data-cat="siswa" role="tab" aria-selected="false">
        <span>SISWA/SISWI</span>
      </button>
      <button class="cat-btn" data-cat="video" role="tab" aria-selected="false">
        <span>VIDEO</span>
      </button>
      <button class="cat-btn" data-cat="ekstra" role="tab" aria-selected="false">
        <span>EKSTRAKURIKULER</span>
      </button>
    </div>

    <!-- CARDS GRID -->
    <section class="cards" aria-label="Daftar konten galeri" id="galleryGrid">

      <!-- ================= GURU ================= -->
      <!-- ================= GURU (DINAMIS DARI DATABASE) ================= -->
      <?php if (!empty($guruItems)): ?>
        <?php foreach ($guruItems as $g): ?>
          <article class="card" data-type="guru">
            <div class="card-image">

              <!-- badge utama -->
              <?php if (!empty($g['jabatan_utama'])): ?>
                <div class="card-badge"><?= esc($g['jabatan_utama']) ?></div>
              <?php else: ?>
                <div class="card-badge">Guru & Staf</div>
              <?php endif; ?>

              <!-- foto -->
              <?php if (!empty($g['foto']) && is_file(FCPATH . 'uploads/guru-staf/' . $g['foto'])): ?>
                <img src="<?= base_url('uploads/guru-staf/' . $g['foto']) ?>" alt="<?= esc($g['nama']) ?>">
              <?php else: ?>
                <img src="https://via.placeholder.com/400x500/cccccc/ffffff?text=No+Photo" alt="No Photo">
              <?php endif; ?>
            </div>

            <div class="card-info">
              <h3 class="card-name"><?= esc($g['nama']) ?></h3>

              <p class="card-nip">
                NIP: <?= esc(!empty($g['nip']) ? $g['nip'] : '-') ?>
              </p>

              <!-- jabatan tambahan -->
              <?php if (!empty($g['jabatan_tambahan'])): ?>
                <p class="card-position" style="font-size:13px;color:#666">
                  <?= esc($g['jabatan_tambahan']) ?>
                </p>
              <?php endif; ?>

              <!-- mapel -->
              <?php if (!empty($g['mapel'])): ?>
                <p class="card-position" style="font-size:13px;color:#666">
                  Mapel: <?= esc($g['mapel']) ?>
                </p>
              <?php endif; ?>
            </div>
          </article>
        <?php endforeach; ?>
      <?php else: ?>
        <!-- kalau belum ada data guru di DB -->
        <article class="card" data-type="guru">
          <div class="card-image">
            <div class="card-badge">Guru & Staf</div>
            <img src="https://via.placeholder.com/400x500/cccccc/ffffff?text=Belum+Ada+Data" alt="Belum ada data">
          </div>
          <div class="card-info">
            <h3 class="card-name">Belum ada data guru/staf</h3>
            <p class="card-nip">Silakan input dari Admin Panel.</p>
            <p class="card-position">-</p>
          </div>
        </article>
      <?php endif; ?>


<!-- ================= SISWA ================= -->
<?php if (!empty($siswaItems)): ?>
  <?php foreach ($siswaItems as $s): ?>
    <article class="card student-card" data-type="siswa">
      <div class="card-image">

        <div class="card-badge">
          <?= esc($s['kelas']) ?>
        </div>

        <?php if (!empty($s['foto']) && is_file(FCPATH.'uploads/siswa/'.$s['foto'])): ?>
          <img src="<?= base_url('uploads/siswa/'.$s['foto']) ?>"
               alt="<?= esc($s['nama']) ?>">
        <?php else: ?>
          <img src="https://via.placeholder.com/400x500/4A90C7/ffffff?text=Siswa"
               alt="No Photo">
        <?php endif; ?>
      </div>

      <div class="card-info">
        <h3 class="card-name"><?= esc($s['nama']) ?></h3>

        <p class="card-position">
          Kelas <?= esc($s['kelas']) ?>
        </p>

        <!-- ✅ TAMBAHAN NISN -->
        <?php if (!empty($s['nisn'])): ?>
          <p class="card-nip">
            NISN: <?= esc($s['nisn']) ?>
          </p>
        <?php endif; ?>
      </div>
    </article>
  <?php endforeach; ?>
<?php else: ?>
  <article class="card student-card" data-type="siswa">
    <div class="card-image">
      <div class="card-badge">Siswa</div>
      <img src="https://via.placeholder.com/400x500/cccccc/ffffff?text=Belum+Ada+Data">
    </div>
    <div class="card-info">
      <h3 class="card-name">Belum ada data siswa</h3>
      <p class="card-position">Silakan hubungi admin</p>
    </div>
  </article>
<?php endif; ?>

<!-- ================= VIDEO ================= -->
<!-- ================= VIDEO ================= -->
<?php if (!empty($videoItems)): ?>
  <?php foreach ($videoItems as $v): ?>

    <?php
      // Ambil ID YouTube
      preg_match(
        '%(?:youtube\.com/(?:[^/]+/.+/|(?:v|e(?:mbed)?)/|.*[?&]v=)|youtu\.be/)([^"&?/ ]{11})%i',
        $v['link_youtube'],
        $match
      );
      $youtubeId = $match[1] ?? null;
    ?>

    <?php if ($youtubeId): ?>
      <article class="card video-card" data-type="video" data-youtube="<?= esc($v['link_youtube']) ?>">
        <div class="card-image">
          <img src="https://img.youtube.com/vi/<?= $youtubeId ?>/hqdefault.jpg" alt="<?= esc($v['judul']) ?>">
          <div class="play-overlay"><i class="fa-solid fa-play"></i></div>
        </div>

        <div class="card-info">
          <h3 class="card-name"><?= esc($v['judul']) ?></h3>
          <div class="video-meta">
            <span><i class="fa-regular fa-calendar"></i> <?= esc($v['tahun'] ?? '') ?></span>
          </div>
        </div>
      </article>
    <?php endif; ?>

  <?php endforeach; ?>
<?php else: ?>
  <p style="margin-top:20px;color:#666">Belum ada video.</p>
<?php endif; ?>

     <!-- ================= EKSTRA (DINAMIS) ================= -->
<?php if (!empty($ekstraItems)): ?>
  <?php foreach ($ekstraItems as $e): ?>
    <article class="card ekskul-card" data-type="ekstra">
      <div class="card-image">
        <div class="card-badge">Ekskul</div>

        <?php if (!empty($e['foto']) && is_file(FCPATH . 'uploads/ekstrakurikuler/' . $e['foto'])): ?>
          <img src="<?= base_url('uploads/ekstrakurikuler/' . $e['foto']) ?>"
               alt="<?= esc($e['nama']) ?>">
        <?php else: ?>
          <img src="https://via.placeholder.com/400x500/4A90C7/ffffff?text=Ekskul">
        <?php endif; ?>

        <?php if (!empty($e['ikon'])): ?>
          <div class="ekskul-icon">
            <i class="fa-solid fa-<?= esc($e['ikon']) ?>"></i>
          </div>
        <?php endif; ?>
      </div>

      <div class="card-info">
        <h3 class="card-name"><?= esc($e['nama']) ?></h3>

        <p class="ekskul-description">
          <?= esc($e['deskripsi']) ?>
        </p>

        <div class="ekskul-footer">
          <?php if (!empty($e['pembina'])): ?>
            <span class="ekskul-pembina">
              Pembina: <?= esc($e['pembina']) ?>
            </span>
          <?php endif; ?>

          <?php if (!empty($e['jumlah_anggota'])): ?>
            <span class="ekskul-members">
              Anggota: <?= esc($e['jumlah_anggota']) ?>+
            </span>
          <?php endif; ?>
        </div>
      </div>
    </article>
  <?php endforeach; ?>
<?php else: ?>
  <article class="card ekskul-card" data-type="ekstra">
    <div class="card-image">
      <div class="card-badge">Ekskul</div>
      <img src="https://via.placeholder.com/400x500/cccccc/ffffff?text=Belum+Ada+Ekskul">
    </div>
    <div class="card-info">
      <h3 class="card-name">Belum ada data ekstrakurikuler</h3>
      <p class="ekskul-description">Silakan input dari Admin Panel</p>
    </div>
  </article>
<?php endif; ?>

    </section>
  </main>

  <!-- MODAL VIDEO (untuk play youtube) -->
  <div class="video-modal" id="videoModal" aria-hidden="true">
    <div class="video-modal__backdrop" id="videoBackdrop"></div>
    <div class="video-modal__content" role="dialog" aria-modal="true" aria-label="Video">
      <button class="video-modal__close" id="videoClose" aria-label="Tutup video">&times;</button>
      <div class="video-modal__frame">
        <iframe id="modalFrame" src="" allow="autoplay; encrypted-media" allowfullscreen></iframe>
      </div>
    </div>
  </div>

  <script>
// Hamburger Menu Toggle
document.addEventListener('DOMContentLoaded', function() {
    // Buat elemen hamburger button
    const hamburger = document.createElement('div');
    hamburger.className = 'hamburger';
    hamburger.innerHTML = '<span></span><span></span><span></span>';
    
    // Tambahkan hamburger ke dalam nav
    const nav = document.querySelector('nav');
    nav.appendChild(hamburger);
    
    // Get menu ul
    const navMenu = document.querySelector('nav ul');
    
    // Toggle menu saat hamburger diklik
    hamburger.addEventListener('click', function() {
        this.classList.toggle('active');
        navMenu.classList.toggle('active');
    });
    
    // Close menu saat link diklik
    const navLinks = document.querySelectorAll('nav ul a');
    navLinks.forEach(link => {
        link.addEventListener('click', function() {
            hamburger.classList.remove('active');
            navMenu.classList.remove('active');
        });
    });
    
    // Close menu saat klik di luar
    document.addEventListener('click', function(e) {
        if (!nav.contains(e.target)) {
            hamburger.classList.remove('active');
            navMenu.classList.remove('active');
        }
    });
});
</script>

  <script>
    // ====== FILTER KATEGORI ======
    const buttons = document.querySelectorAll(".cat-btn");
    const cards = document.querySelectorAll(".cards .card");

    function applyFilter(category) {
      cards.forEach(card => {
        const type = card.getAttribute("data-type");
        card.style.display = (type === category) ? "" : "none";
      });
    }

    // default: tampil guru
    applyFilter("guru");

    buttons.forEach(btn => {
      btn.addEventListener("click", () => {
        buttons.forEach(b => {
          b.classList.remove("is-active");
          b.setAttribute("aria-selected", "false");
        });
        btn.classList.add("is-active");
        btn.setAttribute("aria-selected", "true");

        const category = btn.getAttribute("data-cat");
        applyFilter(category);
      });
    });

    // ====== VIDEO MODAL (Youtube) ======
    const modal = document.getElementById("videoModal");
    const modalFrame = document.getElementById("modalFrame");
    const closeBtn = document.getElementById("videoClose");
    const backdrop = document.getElementById("videoBackdrop");

    function getYoutubeId(url) {
      if (!url) return null;
      const patterns = [
        /youtu\.be\/([^?&/]+)/i,
        /youtube\.com\/watch\?v=([^?&/]+)/i,
        /youtube\.com\/embed\/([^?&/]+)/i,
        /youtube\.com\/shorts\/([^?&/]+)/i,
      ];
      for (const re of patterns) {
        const m = url.match(re);
        if (m && m[1]) return m[1];
      }
      return null;
    }

    function openVideo(url) {
      const videoId = getYoutubeId(url);
      if (!videoId) return;

      modal.setAttribute("aria-hidden", "false");
      modal.classList.add("is-open");

      modalFrame.src = `https://www.youtube.com/embed/${videoId}?autoplay=1&mute=1&rel=0`;
    }

    function closeVideo() {
      modal.setAttribute("aria-hidden", "true");
      modal.classList.remove("is-open");
      modalFrame.src = "";
    }

    document.querySelectorAll(".card.video-card").forEach(card => {
      card.addEventListener("click", () => {
        const url = card.getAttribute("data-youtube");
        openVideo(url);
      });
    });

    closeBtn.addEventListener("click", closeVideo);
    backdrop.addEventListener("click", closeVideo);
    document.addEventListener("keydown", (e) => {
      if (e.key === "Escape") closeVideo();
    });
  </script>

</body>
</html>
